<?php

use Elementor\Core\Base\Module;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Element_Base;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Settings\Manager;

defined( 'ABSPATH' ) || exit;

class LD_Global_Controls extends Module {

	public function __construct() {
		add_action( 'elementor/element/kit/section_settings-site-identity/after_section_end', array( $this, 'tweak_siteidentity_section' ), 999, 2 );
		add_action( 'elementor/element/kit/section_global_colors/after_section_end', array( $this, 'tweak_globalcolors_section' ), 999, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_header_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_footer_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_post_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_portfolio_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_sizeguide_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_sticky_atc_options' ), 250, 2 );
		add_action( 'elementor/element/after_section_end', array( $this, 'register_archives_options' ), 250, 2 );

		// Custom CSS
		add_action( 'elementor/element/kit/section_custom_css_pro/after_section_end', array( $this, 'register_custom_css_section' ), 20, 2 );
		add_action( 'elementor/css-file/post/parse', [ $this, 'lqd_add_custom_css' ] );

	}

	public function get_name() {
		return 'hub-global-controls';
	}

	public function register_header_options( Controls_Stack $element, $section_id ) {
		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$section_name = 'lqd_header_options_hide';

		if ( get_post_type() === 'liquid-header' ){
			$section_name = 'lqd_header_options';
		}

		// Header Design Options
		$element->start_controls_section(
			$section_name,
			array(
				'label' => __( 'Header design options', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		// $element->add_control(
		// 	'header_apply',
		// 	[
		// 		'label' => __( 'Apply changes', 'logistics-hub-core' ),
		// 		'description' => __( 'This option allows you to see the changes without refreshing the page.', 'logistics-hub-core' ),
		// 		'type' => Controls_Manager::BUTTON,
		// 		'separator' => 'after',
		// 		'button_type' => 'success liquid-page-refresh',
		// 		'event' => 'liquid:page:refresh',
		// 		'text' => __( 'Apply', 'logistics-hub-core' ),
		// 	]
		// );

		$element->add_control(
			'header_overlay',
			[
				'label' => __( 'Overlay?', 'logistics-hub-core' ),
				'description' => __( 'Placing the header on top of the content.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$element->add_control(
			'header_sticky',
			[
				'label' => __( 'Enable sticky header?', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
			]
		);

		$element->add_responsive_control(
			'header_sticky_offset',
			[
				'label' => esc_html__( 'Offset', 'logistics-hub-core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'condition' => [
					'header_sticky' => 'yes'
				]
			]
		);

		$element->end_controls_section();

	}

	public function register_footer_options( Controls_Stack $element, $section_id ) {
		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$section_name = 'lqd_footer_options_hide';

		if ( get_post_type() === 'liquid-footer' ){
			$section_name = 'lqd_footer_options';
		}

		// Footer Design Options
		$element->start_controls_section(
			$section_name,
			array(
				'label' => __( 'Footer options', 'aihub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$element->add_control(
			'footer_sticky',
			[
				'label' => __( 'Enable sticky footer?', 'aihub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
			]
		);

		$element->end_controls_section();

	}

	public function register_post_options( Controls_Stack $element, $section_id ) {
		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$is_edit_mode = \Elementor\Plugin::$instance->editor->is_edit_mode();
		$post_type = get_post_type( get_the_ID() );

		// Titlewrapper options
		if (
			(
				$is_edit_mode &&
				$post_type === 'liquid-title-wrapper'
			) ||
			(
				!$is_edit_mode
			)
		) {

			$wrapper_selector = '.lqd-titlebar';

			if ( $is_edit_mode ) {
				$wrapper_selector = '{{WRAPPER}}';
			}

			// Page Options
			$element->start_controls_section(
				'lqd_post_titlewrapper_options',
				[
					'label' => __( 'Titlewrapper options', 'logistics-hub-core' ),
					'tab'   => Controls_Manager::TAB_SETTINGS,
				]
			);

			$element->add_control(
				'lqd_title_wrapper_bg_heading',
				[
					'label' => esc_html__( 'Background', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
				]
			);

			$element->add_group_control(
				'liquid-background-css',
				[
					'name' => 'lqd_title_wrapper_bg',
					'types' => [ 'classic', 'gradient' ],
					'selector' => $wrapper_selector . ' .lqd-titlebar-bg',
					'apply_other_bg_props_to' => $wrapper_selector . ' .lqd-titlebar-bg',
				]
			);

			$element->add_control(
				'lqd_title_wrapper_bg_overlay_heading',
				[
					'label' => esc_html__( 'Background overlay', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before'
				]
			);

			$element->add_group_control(
				'liquid-background-css',
				[
					'name' => 'lqd_title_wrapper_bg_overlay',
					'types' => [ 'classic', 'gradient' ],
					'selector' => $wrapper_selector . ' .lqd-titlebar-bg-overlay',
					'apply_other_bg_props_to' => $wrapper_selector . ' .lqd-titlebar-bg',
				]
			);

			$element->end_controls_section();
		}

		// Page, Header and Footer Options
		if ( $post_type === 'post' || $post_type === 'page' || $post_type === 'liquid-portfolio' ) {

			// Page Options
			$element->start_controls_section(
				'lqd_post_options',
				[
					'label' => __( 'Page options', 'logistics-hub-core' ),
					'tab'   => Controls_Manager::TAB_SETTINGS,
				]
			);

			$element->add_control(
				'lqd_page_title_wrapper_custom_title',
				[
					'label' => esc_html__( 'Title Wrapper Custom Title', 'logistics-hub-core' ),
					'description' => esc_html__( 'This option only works with [ld_archive_title] shortcode', 'logistics-hub-core' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( '', 'logistics-hub-core' ),
					'placeholder' => esc_html__( 'Page title', 'logistics-hub-core' ),
					'ai' => [
						'active' => false,
					],
					'label_block' => true
				]
			);

			$element->add_control(
				'lqd_page_title_wrapper_custom_description',
				[
					'label' => esc_html__( 'Title Wrapper Custom Description', 'logistics-hub-core' ),
					'description' => esc_html__( 'This option only works with [ld_archive_desc] shortcode', 'logistics-hub-core' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__( '', 'logistics-hub-core' ),
					'placeholder' => esc_html__( 'Description', 'logistics-hub-core' ),
					'ai' => [
						'active' => false,
					],
					'label_block' => true
				]
			);

			$element->add_control(
				'lqd_page_title_wrapper_bg_heading',
				[
					'label' => esc_html__( 'Title Wrapper Background', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$element->add_group_control(
				'liquid-background-css',
				[
					'name' => 'lqd_page_title_wrapper_bg',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .lqd-titlebar .lqd-titlebar-bg',
					'apply_other_bg_props_to' => '{{WRAPPER}} .lqd-titlebar .lqd-titlebar-bg'
				]
			);

			$element->add_control(
				'lqd_page_title_wrapper_bg_overlay_heading',
				[
					'label' => esc_html__( 'Title Wrapper Background overlay', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
				]
			);

			$element->add_group_control(
				'liquid-background-css',
				[
					'name' => 'lqd_page_title_wrapper_bg_overlay',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .lqd-titlebar .lqd-titlebar-bg-overlay',
					'apply_other_bg_props_to' => '{{WRAPPER}} .lqd-titlebar .lqd-titlebar-bg-overlay'
				]
			);

			$element->end_controls_section();

		}

		// Sidebar Options
		if ( $post_type === 'post' || $post_type === 'page' ){
			// Sidebar Options
			$element->start_controls_section(
				'lqd_post_sidebar_options',
				[
					'label' => __( 'Page sidebar options', 'logistics-hub-core' ),
					'tab'   => Controls_Manager::TAB_SETTINGS,
				]
			);

			$element->add_control(
				'lqd_post_sidebar_options_apply',
				[
					'label' => __( 'Apply changes', 'logistics-hub-core' ),
					'description' => __( 'This option allows you to see the changes without refreshing the page.', 'logistics-hub-core' ),
					'type' => Controls_Manager::BUTTON,
					'separator' => 'after',
					'button_type' => 'success liquid-page-refresh',
					'event' => 'liquid:page:refresh',
					'text' => __( 'Apply', 'logistics-hub-core' ),
				]
			);

			$element->add_control(
				'liquid_sidebar_one',
				[
					'label' => __( 'Select sidebar', 'logistics-hub-core' ),
					'type' => Controls_Manager::SELECT,
					'label_block' => true,
					'options' => liquid_helper()->get_sidebars( array( 'none' => esc_html__( 'No Sidebar', 'logistics-hub-core' ), 'main' => esc_html__( 'Main Sidebar', 'logistics-hub-core' ) ) ),
					'save_default' => true,
					'separator' => 'after',
					'description'  => __( 'Select sidebar that will display on this page. Choose "No Sidebar" for full width.', 'logistics-hub-core' ),
				]
			);

			$element->add_control(
				'liquid_sidebar_position',
				[
					'label' => __( 'Sidebar position', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'logistics-hub-core' ),
							'icon' => 'eicon-h-align-left',
						],
						'0' => [
							'title' => __( 'Use Global Settings', 'logistics-hub-core' ),
							'icon' => 'fa fa-adjust',
						],
						'right' => [
							'title' => __( 'Right', 'logistics-hub-core' ),
							'icon' => 'eicon-h-align-right',
						],
					],
					'default' => '0',
					'toggle' => false,
					'condition' => [
						'liquid_sidebar_one!' => [ '', 'none' ],
					],
				]
			);

			$element->add_control(
				'sidebar_widgets_style',
				[
					'label' => __( 'Sidebar style', 'logistics-hub-core' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => __( 'Use Global Settings', 'logistics-hub-core' ),
						'sidebar-widgets-default' => __( 'Default', 'logistics-hub-core' ),
						'sidebar-widgets-outline' => __( 'Outline', 'logistics-hub-core' ),
					],
					'condition' => [
						'liquid_sidebar_one!' => [ '', 'none' ],
					],
				]
			);
			$element->end_controls_section();
		}

		if ( $post_type === 'post' ){

			$element->start_controls_section(
				'lqd_singlepost_options',
				[
					'label' => __( 'Post options', 'logistics-hub-core' ),
					'tab'   => Controls_Manager::TAB_SETTINGS,
				]
			);

			$element->add_control(
				'lqd_post_singlepost_options_apply',
				[
					'label' => __( 'Apply changes', 'logistics-hub-core' ),
					'description' => __( 'This option allows you to see the changes without refreshing the page.', 'logistics-hub-core' ),
					'type' => Controls_Manager::BUTTON,
					'separator' => 'after',
					'button_type' => 'success liquid-page-refresh',
					'event' => 'liquid:page:refresh',
					'text' => __( 'Apply', 'logistics-hub-core' ),
				]
			);

			$element->add_control(
				'post_style',
				[
					'label' => __( 'Single post style', 'logistics-hub-core' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						''  => __( 'Use Global Settings', 'logistics-hub-core' ),
						'modern-full-screen'  => __( 'Modern Full Screen', 'logistics-hub-core' ),
						'wide'  => __( 'Wide', 'logistics-hub-core' ),
					],
				]
			);

			$element->add_control(
				'liquid_post_cover_style_image',
				[
					'label' => __( 'Cover image', 'logistics-hub-core' ),
					'description' => __( 'Will override the featured image in single post', 'logistics-hub-core' ),
					'type' => Controls_Manager::MEDIA,
					'separator' => 'before',
				]
			);

			$element->add_control(
				'liquid_post_cover_overlay_color',
				[
					'label' => esc_html__( 'Post image overlay', 'logistics-hub-core' ),
					'type' => 'liquid-color',
					'selectors' => [
						'{{WRAPPER}} .lqd-post-media .lqd-post-cover-overlay' => 'background: {{VALUE}}',
					],
				]
			);

			$element->add_control(
				'post_social_box_enable',
				[
					'label' => __( 'Social sharing box', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display the social sharing box on single posts.', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'post_meta_enable',
				[
					'label' => __( 'Author info meta', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display the author meta.', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'post_author_box_enable',
				[
					'label' => __( 'Author info box', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display the author info box below posts', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'post_author_role_enable',
				[
					'label' => __( 'Author role', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display the author role in info box below posts.', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'post_navigation_enable',
				[
					'label' => __( 'Previous/next pagination', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display the previous/next post pagination for single posts.', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'blog_archive_link',
				[
					'label' => __( 'Blog archive url', 'logistics-hub-core' ),
					'description' => __( 'Custom link to post on navigation to link to the default blog archive', 'logistics-hub-core' ),
					'type' => Controls_Manager::URL,
					'placeholder' => __( 'https://your-link.com', 'logistics-hub-core' ),
					'show_external' => true,
					'default' => [
						'url' => '',
						'is_external' => true,
						'nofollow' => true,
					],
					'condition' => [
						'post_navigation_enable' => 'on',
					],
				]
			);

			$element->add_control(
				'post_related_enable',
				[
					'label' => __( 'Related posts', 'logistics-hub-core' ),
					'description' => __( 'Turn on to display related posts/projects on single posts.', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
				]
			);

			$element->add_control(
				'post_related_style',
				[
					'label' => __( 'Related posts section style', 'logistics-hub-core' ),
					'description' => __( 'Select desired style for the related posts section to display on single post', 'logistics-hub-core' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						''  => __( 'Use Global Settings', 'logistics-hub-core' ),
						'style-1'  => __( 'Style 1', 'logistics-hub-core' ),
						'style-2'  => __( 'Style 2', 'logistics-hub-core' ),
						'style-3'  => __( 'Style 3', 'logistics-hub-core' ),
					],
					'condition' => [
						'post_related_enable' => 'on',
					],
				]
			);

			$element->add_control(
				'post_related_title',
				[
					'label' => __( 'Related posts section title', 'logistics-hub-core' ),
					'type' => Controls_Manager::TEXT,
					'condition' => [
						'post_related_enable' => 'on',
					],
				]
			);

			$element->add_control(
				'post_related_number',
				[
					'label' => __( 'Number of related projects', 'logistics-hub-core' ),
					'type' => Controls_Manager::NUMBER,
					'min' => 2,
					'max' => 5,
					'step' => 1,
					'default' => 2,
					'condition' => [
						'post_related_enable' => 'on',
					],
				]
			);

			$element->add_control(
				'post_reading_time',
				[
					'label' => __( 'Post reading time', 'logistics-hub-core' ),
					'description' => __( 'Will display the text about time needs to read the article', 'logistics-hub-core' ),
					'type' => Controls_Manager::CHOOSE,
					'separator' => 'before',
					'options' => [
						'' => [
							'title' => esc_html__( 'Global', 'logistics-hub-core' ),
							'icon' => 'eicon-global-settings',
						],
						'on' => [
							'title' => esc_html__( 'On', 'logistics-hub-core' ),
							'icon' => 'eicon-check',
						],
						'off' => [
							'title' => esc_html__( 'Off', 'logistics-hub-core' ),
							'icon' => 'eicon-close',
						],
					],
					'separator' => 'before',
					'condition' => [
						'post_meta_enable!' => 'off'
					]
				]
			);

			$element->add_control(
				'post_reading_time_label',
				[
					'label' => __( 'Label', 'logistics-hub-core' ),
					'description' => __( 'Add label after the reading time', 'logistics-hub-core' ),
					'default' => __( 'min read', 'logistics-hub-core' ),
					'type' => Controls_Manager::TEXT,
					'condition' => [
						'post_reading_time' => 'on'
					]
				]
			);

			$element->end_controls_section();
		}

	}

	public function register_portfolio_options( Controls_Stack $element, $section_id ) {
		if ( 'document_settings' !== $section_id ) {
			return;
		}

		if ( get_post_type() !== 'liquid-portfolio' ) {
			return;
		}

		$element->start_controls_section(
			'lqd_portfolio_options',
			[
				'label' => __( 'Portfolio general', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$element->add_control(
			'lqd_portfolio_options_apply',
			[
				'label' => __( 'Apply changes', 'logistics-hub-core' ),
				'description' => __( 'This option allows you to see the changes without refreshing the page.', 'logistics-hub-core' ),
				'type' => Controls_Manager::BUTTON,
				'separator' => 'after',
				'button_type' => 'success liquid-page-refresh',
				'event' => 'liquid:page:refresh',
				'text' => __( 'Apply', 'logistics-hub-core' ),
			]
		);

		$element->add_control(
			'portfolio_description',
			[
				'label' => __( 'Portfolio description', 'logistics-hub-core' ),
				'type' => Controls_Manager::WYSIWYG,
			]
		);

		$element->add_control(
			'portfolio_subtitle',
			[
				'label' => __( 'Subtitle', 'logistics-hub-core' ),
				'description' => __( 'Manage the subtitle of portfolio listing', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
			]
		);

		$element->add_control(
			'portfolio_style',
			[
				'label' => __( 'Portfolio style', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'custom',
				'separator' => 'before',
				'options' => [
					'custom' => __( 'Custom', 'logistics-hub-core' ),
					'default' => __( 'Basic', 'logistics-hub-core' ),
				],
			]
		);

		$element->add_control(
			'portfolio_width',
			[
				'label' => __( 'Width', 'logistics-hub-core' ),
				'description' => __( 'Defines the width of the featured image on the portfolio listing page', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'separator' => 'before',
				'options' => [
					'' => __( 'Default', 'logistics-hub-core' ),
					'auto' => __( 'Auto - width determined by thumbnail width', 'logistics-hub-core' ),
					'2' => __( '2 columns - 1/6', 'logistics-hub-core' ),
					'3' => __( '3 columns - 1/4', 'logistics-hub-core' ),
					'4' => __( '4 columns - 1/3', 'logistics-hub-core' ),
					'5' => __( '5 columns - 5/12', 'logistics-hub-core' ),
					'6' => __( '6 columns - 1/2', 'logistics-hub-core' ),
					'7' => __( '7 columns - 7/12', 'logistics-hub-core' ),
					'8' => __( '8 columns - 2/3', 'logistics-hub-core' ),
					'9' => __( '9 columns - 3/4', 'logistics-hub-core' ),
					'10' => __( '10 columns - 5/6', 'logistics-hub-core' ),
					'11' => __( '11 columns - 11/12', 'logistics-hub-core' ),
					'12' => __( '12 columns - 12/12', 'logistics-hub-core' ),
				],
			]
		);

		$element->add_control(
			'_portfolio_image_size',
			[
				'label' => __( 'Crop thumbnail image?', 'logistics-hub-core' ),
				'description' => __( 'Choose a dimension for your portfolio thumb. 1. The images need to regenerated after this. 2. Image resolutions need to be greater than selected resolution.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'separator' => 'before',
				'options' => [
					'' => __( 'Select a size', 'logistics-hub-core' ),
					'liquid-portfolio' => __( 'Default - (760 x 520)', 'logistics-hub-core' ),
					'liquid-portfolio-sq' => __( 'Square - (760 x 640)', 'logistics-hub-core' ),
					'liquid-portfolio-big-sq' => __( 'Bigger Square - (1520 x 1280)', 'logistics-hub-core' ),
					'liquid-portfolio-portrait' => __( 'Vertical - (700 x 1000)', 'logistics-hub-core' ),
					'liquid-portfolio-wide' => __( 'Horizontal - (1200 x 590)', 'logistics-hub-core' ),
					'liquid-packery-wide' => __( 'Packery Horizontal - (1140 x 740)', 'logistics-hub-core' ),
					'liquid-packery-portrait' => __( 'Packery Vertical - (540 x 740)', 'logistics-hub-core' ),
				],
			]
		);
		$element->end_controls_section();

		$element->start_controls_section(
			'lqd_portfolio_meta_options',
			[
				'label' => __( 'Portfolio meta', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$element->add_control(
			'lqd_portfolio_meta_options_apply',
			[
				'label' => __( 'Apply changes', 'logistics-hub-core' ),
				'description' => __( 'This option allows you to see the changes without refreshing the page.', 'logistics-hub-core' ),
				'type' => Controls_Manager::BUTTON,
				'separator' => 'after',
				'button_type' => 'success liquid-page-refresh',
				'event' => 'liquid:page:refresh',
				'text' => __( 'Apply', 'logistics-hub-core' ),
			]
		);

		$element->add_control(
			'portfolio_badge',
			[
				'label' => __( 'Badge', 'logistics-hub-core' ),
				'description' => __( 'Will show badge for the style 6 of the portfolio listing', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
			]
		);

		$element->add_control(
			'portfolio_website',
			[
				'label' => __( 'External url', 'logistics-hub-core' ),
				'type' => Controls_Manager::URL,
				'separator' => 'before',
				'placeholder' => __( 'https://your-link.com', 'logistics-hub-core' ),
				'show_external' => false,
				'default' => [
					'url' => '',
				],
			]
		);

		$element->add_control(
			'portfolio_attributes',
			[
				'label' => __( 'Attributes', 'logistics-hub-core' ),
				'description' => __( 'Add custom portfolio attributes. Divide by | label with value ( Label | Value ). Each row (Enter) is a new item', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'separator' => 'before',
				'default' =>  __( 'Client | Liquid Themes', 'logistics-hub-core' ),
			]
		);

		$element->end_controls_section();

	}

	public function register_sizeguide_options ( Controls_Stack $element, $section_id ) {

		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$section_name = 'lqd_sizeguide_show_tax_hide';
		if ( get_post_type() === 'ld-product-sizeguide' ){
			$section_name = 'lqd_sizeguide_show_tax';
		}

		$element->start_controls_section(
			$section_name,
			[
				'label' => __( 'Size Guide Options', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$element->add_control(
			'lqd_sizeguide_type',
			[
				'label' => esc_html__( 'Type', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'direct',
				'options' => [
					'direct' => esc_html__( 'Direct', 'logistics-hub-core' ),
					'modal'  => esc_html__( 'Modal', 'logistics-hub-core' ),
				],
			]
		);

		$element->add_control(
			'lqd_sizeguide_popover',
			[
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label' => esc_html__( 'Button Style', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Default', 'logistics-hub-core' ),
				'label_on' => esc_html__( 'Custom', 'logistics-hub-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'selectors' => [
					'.lqd-size-guide-button i' => 'margin-right: 0.5em',
				],
				'condition' => [
					'lqd_sizeguide_type' => 'modal'
				]
			]
		);

		$element->start_popover();

			$element->add_control(
				'lqd_sizeguide_btn_text',
				[
					'label' => esc_html__( 'Button Text', 'logistics-hub-core' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Size Guide', 'logistics-hub-core' ),
				]
			);

			$element->add_control(
				'lqd_sizeguide_btn_icon',
				[
					'label' => esc_html__( 'Icon', 'logistics-hub-core' ),
					'type' => Controls_Manager::ICONS,
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);

			$element->add_control(
				'lqd_sizeguide_btn_colors_heading',
				[
					'label' => esc_html__( 'Colors', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$element->add_control(
				'lqd_sizeguide_btn_color',
				[
					'label' => esc_html__( 'Text Color', 'logistics-hub-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'.lqd-size-guide-button' => 'color: {{VALUE}}',
					],
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);

			$element->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'lqd_sizeguide_btn_bg',
					'label' => esc_html__( 'Background', 'logistics-hub-core' ),
					'types' => [ 'classic', 'gradient' ],
					'exclude' => [ 'image' ],
					'selector' => '.lqd-size-guide-button',
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);

			$element->add_control(
				'lqd_sizeguide_btn_colors_hover_heading',
				[
					'label' => esc_html__( 'Hover Colors', 'logistics-hub-core' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$element->add_control(
				'lqd_sizeguide_btn_color_hover',
				[
					'label' => esc_html__( 'Text Color', 'logistics-hub-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'.lqd-size-guide-button:hover' => 'color: {{VALUE}}',
					],
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);

			$element->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'lqd_sizeguide_btn_bg_hover',
					'label' => esc_html__( 'Background', 'logistics-hub-core' ),
					'types' => [ 'classic', 'gradient' ],
					'exclude' => [ 'image' ],
					'selector' => '.lqd-size-guide-button:hover',
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);

			$element->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'lqd_sizeguide_btn_typography',
					'selector' => '.lqd-size-guide-button',
					'condition' => [
						'lqd_sizeguide_popover' => 'yes',
						'lqd_sizeguide_type' => 'modal'
					]
				]
			);


		$element->end_popover();

		$element->add_control(
			'lqd_sizeguide_show_by',
			[
				'label' => esc_html__( 'Show by', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => [
					'all'  => esc_html__( 'All products', 'logistics-hub-core' ),
					'cats'  => esc_html__( 'Category', 'logistics-hub-core' ),
					'products' => esc_html__( 'Product', 'logistics-hub-core' ),
				],
			]
		);

		$element->add_control(
			'lqd_sizeguide_cats',
			[
				'label' => esc_html__( 'Select Categories', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => liquid_helper()->get_available_custom_taxonomies( 'product_cat' ),
				'condition' => [
					'lqd_sizeguide_show_by' => 'cats'
				]
			]
		);

		$element->add_control(
			'lqd_sizeguide_products',
			[
				'label' => esc_html__( 'Select Products', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => liquid_helper()->get_available_custom_post( 'product' ),
				'condition' => [
					'lqd_sizeguide_show_by' => 'products'
				]
			]
		);

		$element->end_controls_section();

	}

	public function register_sticky_atc_options ( Controls_Stack $element, $section_id ) {

		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$section_name = 'lqd_sticky_atc_hide';
		if ( get_post_type() === 'liquid-sticky-atc' ){
			$section_name = 'lqd_sticky_atc_show_tax';
		}

		$element->start_controls_section(
			$section_name,
			[
				'label' => __( 'Sticky Add to Cart Options', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$element->add_control(
			'lqd_sticky_atc_show_by',
			[
				'label' => esc_html__( 'Show by', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => [
					'all'  => esc_html__( 'All products', 'logistics-hub-core' ),
					'cats'  => esc_html__( 'Category', 'logistics-hub-core' ),
					'products' => esc_html__( 'Product', 'logistics-hub-core' ),
				],
			]
		);

		$element->add_control(
			'lqd_sticky_atc_cats',
			[
				'label' => esc_html__( 'Select Categories', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => liquid_helper()->get_available_custom_taxonomies( 'product_cat' ),
				'condition' => [
					'lqd_sticky_atc_show_by' => 'cats'
				]
			]
		);

		$element->add_control(
			'lqd_sticky_atc_products',
			[
				'label' => esc_html__( 'Select Products', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => liquid_helper()->get_available_custom_post( 'product' ),
				'condition' => [
					'lqd_sticky_atc_show_by' => 'products'
				]
			]
		);

		$element->end_controls_section();

	}

	public function register_archives_options ( Controls_Stack $element, $section_id ) {

		if ( 'document_settings' !== $section_id ) {
			return;
		}

		$section_name = 'lqd_archives_hide';
		if ( get_post_type() === 'liquid-archives' ){
			$section_name = 'lqd_archives';
		}

		$element->start_controls_section(
			$section_name,
			[
				'label' => __( 'Layout Condition', 'logistics-hub-core' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$cpts = apply_filters( 'liquid_condition_cpt', array( 'post', 'liquid-portfolio' ) );

		$archive_items = [
			'blog-archive'  => esc_html__( 'Blog Archive', 'logistics-hub-core' ),
			'author-archive' => esc_html__( 'Author Archive', 'logistics-hub-core' ),
			'category-archive' => esc_html__( 'Category Archive', 'logistics-hub-core' ),
			'tag-archive' => esc_html__( 'Tag Archive', 'logistics-hub-core' ),
			'date-archive' => esc_html__( 'Date Archive', 'logistics-hub-core' ),
			'blog-search' => esc_html__( 'Search Page Results', 'logistics-hub-core' ),
			'taxonomy-archive' => esc_html__( 'Taxonomy Archive', 'logistics-hub-core' ),
		];

		foreach ( $cpts as $cpt ) {
			if ( $cpt == 'post' ){ continue; }
            $archive_items[$cpt] = get_post_type_object( $cpt )->labels->archives;
        }

		$element->add_control(
			'lqd_archives_rule',
			[
				'label' => esc_html__( 'Rule', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => $archive_items,
			]
		);

		$element->end_controls_section();

	}

	public function tweak_siteidentity_section( $element ) {
		$element->start_injection(
			array(
				'of' => 'site_logo',
				'at' => 'before',
			)
		);

		$element->add_control(
			'header_logo',
			[
				'label' => __( 'Default logo', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->add_control(
			'header_sticky_logo',
			[
				'label' => __( 'Sticky header logo', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->add_control(
			'header_dark_logo',
			[
				'label' => __( 'Dark logo', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->add_control(
			'favicon',
			[
				'label' => __( 'Favicon', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->add_control(
			'iphone_icon',
			[
				'label' => __( 'Apple iphone icon', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->add_control(
			'ipad_icon',
			[
				'label' => __( 'Apple ipad icon', 'logistics-hub-core' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$element->end_injection();
	}

	public function tweak_globalcolors_section( $element ) {
		$element->start_injection(
			array(
				'of' => 'custom_colors',
				'at' => 'after',
			)
		);

		$element->add_control(
			'lqd_init_color_scheme',
			[
				'label' => esc_html__( 'Initial page color scheme', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'None', 'logistics-hub-core' ),
					'system' => esc_html__( 'User system prefrence', 'logistics-hub-core' ),
					'light' => esc_html__( 'Light', 'logistics-hub-core' ),
					'dark' => esc_html__( 'Dark', 'logistics-hub-core' ),
				],
			]
		);

		$element->end_injection();
	}

	public function register_custom_css_section( Controls_Stack $element, $section_id ) {

		$element->start_controls_section(
			'lqd_custom_css_section',
			[
				'label' => __( 'Liquid Custom Css', 'logistics-hub-core' ),
				'tab' => 'settings-custom-css',
			]
		);

		$element->add_control(
			'lqd_custom_css',
			[
				'type' => Controls_Manager::CODE,
				'language' => 'css'
			]
		);

		$element->end_controls_section();
	}

	public function lqd_add_custom_css( $post_css ) {

		$custom_css = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend()->get_settings_for_display('lqd_custom_css');

		$custom_css = trim( $custom_css );

		if ( empty( $custom_css ) ) {
			return;
		}

		// Add a css comment
		$custom_css = '/* Start Liquid custom CSS */' . $custom_css . '/* End Liquid custom CSS */';

		$post_css->get_stylesheet()->add_raw_css( $custom_css );
	}

}

new LD_Global_Controls();
